// Title      : Submission.java
// Author     : James Baird
// Created    : Tuesday, 5th October 2004

import java.io.FileWriter;
import java.io.IOException;

public class Submission
{

  public Submission(String filename)
  {
    this.identifier = filename.substring(0, 3);
  }

  public void setSelection1(String selection1)
  {
    this.selection1 = selection1;
  }

  public void setSelection2(String selection2)
  {
    this.selection2 = selection2;
  }

  public void setSelection3(String selection3)
  {
    this.selection3 = selection3;
  }

  public void setSelection4(String selection4)
  {
    this.selection4 = selection4;
  }

  public void setGender(String gender)
  {
    this.gender = gender;
  }

  public void setFrequency(String frequency)
  {
    this.frequency = frequency;
  }

  public void setSource(String source)
  {
    this.source = source;
  }

  public void setScale1(String scale)
  {
    char index = selection1.charAt(2);

    switch (index)
    {
      case '1': scale1 = scale; break;
      case '2': scale2 = scale; break;
      case '3': scale3 = scale; break;
      case '4': scale4 = scale; break;
    } 
  }

  public void setScale2(String scale)
  {
    char index = selection2.charAt(2);

    switch (index)
    {
      case '1': scale1 = scale; break;
      case '2': scale2 = scale; break;
      case '3': scale3 = scale; break;
      case '4': scale4 = scale; break;
    }
  }

  public void setScale3(String scale)
  {
    char index = selection3.charAt(2);

    switch (index)
    {
      case '1': scale1 = scale; break;
      case '2': scale2 = scale; break;
      case '3': scale3 = scale; break;
      case '4': scale4 = scale; break;
    }
  }

  public void setScale4(String scale)
  {
    char index = selection4.charAt(2);

    switch (index)
    {
      case '1': scale1 = scale; break;
      case '2': scale2 = scale; break;
      case '3': scale3 = scale; break;
      case '4': scale4 = scale; break;
    }
  }

  public void setReason1(String reason)
  {
    char index = selection1.charAt(2);

    switch (index)
    {
      case '1': reason1 = reason; break;
      case '2': reason2 = reason; break;
      case '3': reason3 = reason; break;
      case '4': reason4 = reason; break;
    }
  }

  public void setReason2(String reason)
  {
    char index = selection2.charAt(2);

    switch (index)
    {
      case '1': reason1 = reason; break;
      case '2': reason2 = reason; break;
      case '3': reason3 = reason; break;
      case '4': reason4 = reason; break;
    }
  }

  public void setReason3(String reason)
  {
    char index = selection3.charAt(2);

    switch (index)
    {
      case '1': reason1 = reason; break;
      case '2': reason2 = reason; break;
      case '3': reason3 = reason; break;
      case '4': reason4 = reason; break;
    }
  }

  public void setReason4(String reason)
  {
    char index = selection4.charAt(2);

    switch (index)
    {
      case '1': reason1 = reason; break;
      case '2': reason2 = reason; break;
      case '3': reason3 = reason; break;
      case '4': reason4 = reason; break;
    }
  }

  public void setGeneralComments(String generalComments)
  {
    this.generalComments = generalComments;
  }

  public void exportRow(FileWriter outfile, int index, String selection, String scale, String reason) throws IOException
  {
    StringBuffer sb = new StringBuffer();

    sb.append(identifier);

    sb.append(",");

    sb.append(selection.charAt(0));

    sb.append(",");

    sb.append(index);

    sb.append(",");

    sb.append(transformScale(scale));

    sb.append(",");

    sb.append("\"");
    sb.append(transformText(reason));
    sb.append("\"");

    sb.append(",");

    sb.append(transformGender(gender));

    sb.append(",");

    sb.append(transformFrequency(frequency));

    outfile.write(sb.toString() + System.getProperty("line.separator"));
  }

  public void export(FileWriter outfile) throws IOException
  {
    exportRow(outfile, 1, selection1, scale1, reason1);
    exportRow(outfile, 2, selection2, scale2, reason2);
    exportRow(outfile, 3, selection3, scale3, reason3);
    exportRow(outfile, 4, selection4, scale4, reason4);
  }

/*
  public void export(FileWriter outfile) throws IOException
  {
    StringBuffer sb = new StringBuffer();

    sb.append(identifier);

    sb.append(",");

    sb.append("\"");
    sb.append(selection1);
    sb.append("\"");

    sb.append(",");

    sb.append("\"");
    sb.append(selection2);
    sb.append("\"");

    sb.append(",");

    sb.append("\"");
    sb.append(selection3);
    sb.append("\"");

    sb.append(",");

    sb.append("\"");
    sb.append(selection4);
    sb.append("\"");

    sb.append(",");

    sb.append(transformGender(gender));

    sb.append(",");

    sb.append(transformFrequency(frequency));

    sb.append(",");

    sb.append(transformSource(source));

    sb.append(",");

    sb.append(transformScale(scale1));

    sb.append(",");

    sb.append(transformScale(scale2));

    sb.append(",");

    sb.append(transformScale(scale3));

    sb.append(",");

    sb.append(transformScale(scale4));

    sb.append(",\"");

    sb.append(transformText(reason1));

    sb.append("\",\"");

    sb.append(transformText(reason2));

    sb.append("\",\"");

    sb.append(transformText(reason3));

    sb.append("\",\"");

    sb.append(transformText(reason4));

    sb.append("\",\"");

    sb.append(transformText(generalComments));

    sb.append("\"");

    outfile.write(sb.toString() + System.getProperty("line.separator"));
  }
*/

  public String transformGender(String g)
  {
    String result = "";

    if (g.equals("male"))
      result = "1";

    if (g.equals("female"))
      result = "2";

    return result;
  }

  public String transformFrequency(String f)
  {
    String result = "";

    if (f.equals("never"))
      result = "1";

    if (f.equals("sometimes"))
      result = "2";

    if (f.equals("frequently"))
      result = "3";    

    return result;
  }

  public String transformSource(String s)
  {
    String result = "";

    if (s.equals("wordmouth"))
      result = "1";

    if (s.equals("noticeboard"))
      result = "2";

    if (s.equals("internet"))
      result = "3";

    if (s.equals("other"))
      result = "4";

    return result;
  }

  public String transformScale(String s)
  {
    String result = "";

    if (s.equals("definitely_not"))
      result = "1";

    if (s.equals("probably_not"))
      result = "2";

    if (s.equals("probably"))
      result = "3";

    if (s.equals("definitely"))
      result = "4";

    return result;
  }

  public String transformText(String text)
  {
    String result = "";

    for (int i = 0; i < text.length(); i++)
    {
      char c = text.charAt(i);

      if (c < ' ')
        c = ' ';

      if (c == '"')
        c = '\'';

      result += c;
    }

    return result;
  }

  public final static String SELECTION1 = "_selection_1:";
  public final static String SELECTION2 = "_selection_2:";
  public final static String SELECTION3 = "_selection_3:";
  public final static String SELECTION4 = "_selection_4:";
  public final static String GENDER = "_gender:";
  public final static String FREQUENCY = "_frequency:";
  public final static String SOURCE = "_source:";
  public final static String SCALE1 = "_scale_1:";
  public final static String SCALE2 = "_scale_2:";
  public final static String SCALE3 = "_scale_3:";
  public final static String SCALE4 = "_scale_4:";
  public final static String REASON1 = "_reason_1:";
  public final static String REASON2 = "_reason_2:";
  public final static String REASON3 = "_reason_3:";
  public final static String REASON4 = "_reason_4:";
  public final static String GENERALCOMMENTS = "_general_comments:";

  protected String identifier;
  protected String selection1;
  protected String selection2;
  protected String selection3;
  protected String selection4;
  protected String gender;
  protected String frequency;
  protected String source;
  protected String scale1;
  protected String scale2;
  protected String scale3;
  protected String scale4;
  protected String reason1;
  protected String reason2;
  protected String reason3;
  protected String reason4;
  protected String generalComments;

}

